Imports System.Threading
Imports System.Windows.Forms
Imports System.ComponentModel


<DefaultEvent("Idle")> _
Public Class ApplicationEvents
  Inherits System.ComponentModel.Component

  Public Event ApplicationExit As EventHandler
  Public Event Idle As EventHandler
  Public Event ThreadException As ThreadExceptionEventHandler
  Public Event ThreadExit As EventHandler

  Public Sub New()
    AddHandler Application.ApplicationExit, _
      AddressOf DoApplicationExit
    AddHandler Application.Idle, _
      AddressOf DoIdle

    AddHandler Application.ThreadException, _
          AddressOf DoThreadException
    AddHandler Application.ThreadExit, _
          AddressOf DoThreadExit
  End Sub

  Private Sub DoApplicationExit(ByVal sender As Object, _
    ByVal e As System.EventArgs)
    RaiseEvent ApplicationExit(sender, e)
  End Sub

  Private Sub DoIdle(ByVal sender As Object, _
    ByVal e As System.EventArgs)

    RaiseEvent Idle(sender, e)
  End Sub

  Private Sub DoThreadException(ByVal sender As Object, _
    ByVal e As ThreadExceptionEventArgs)

    RaiseEvent ThreadException(sender, e)

  End Sub

  Public Sub DoThreadExit(ByVal sender As Object, _
    ByVal e As System.EventArgs)

    RaiseEvent ThreadExit(sender, e)

  End Sub
End Class
